/*******************************************************************************
 * pvfiles.cpp
 *
 * This module contains ASCII file related code.
 *
 * Author: Christopher J. Cason.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/windows/pvfiles.cpp $
 * $Revision: #14 $
 * $Change: 4537 $
 * $DateTime: 2008/02/09 01:25:49 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#define POVWIN_FILE
#define _WIN32_IE COMMONCTRL_VERSION
#define WIN32_LEAN_AND_MEAN

#include <setjmp.h>
#include <string.h>

#include <windows.h>

#include "pvengine.h"
#include "resource.h"
#include "pvlegal.h"
#include "pvdemo.h"
#include "pvtips.h"

// this must be the last file included
#include "syspovdebug.h"

namespace povwin
{

extern int              message_ychar ;
extern char             ourPath [] ;
extern char             HomePath [] ;

void fill_listbox (HWND hwnd)
{
  char        *p = povlegal_text ;
  char        str [1024] = "" ;
  char        *s = str ;

  while (*p)
  {
    if (*p == '\n')
    {
      *s = '\0' ;
      SendMessage (hwnd, LB_ADDSTRING, 0, (LPARAM) str) ;
      s = str ;
      p++ ;
      continue ;
    }
    *s++ = *p++ ;
  }
  *s = '\0' ;
  SendMessage (hwnd, LB_ADDSTRING, 0, (LPARAM) str) ;
}

void save_povlegal (void)
{
  char        filename [_MAX_PATH + 64] ;
  FILE        *outF ;

  sprintf (filename, "%sPOVLEGAL.DOC", HomePath) ;
  if ((outF = fopen (filename, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create POVLEGAL.DOC", "Cannot save document") ;
    return ;
  }
  if (fwrite (povlegal_text, 1, sizeof (povlegal_text) - 1, outF) != sizeof (povlegal_text) - 1)
  {
    PovMessageBox ("Cannot write to POVLEGAL.DOC", "Cannot save document") ;
    fclose (outF) ;
    return ;
  }
  fclose (outF) ;
  sprintf (filename, "The POV-Ray license was written to the file %sPOVLEGAL.DOC\n\n"
                     "This file is in plain text format and may be viewed and printed "
                     "using notepad or any other text editor. Microsoft Word is not "
                     "required.", HomePath) ;
  PovMessageBox (filename, "POVLEGAL.DOC saved") ;
}

INT_PTR CALLBACK PovLegalDialogProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  DRAWITEMSTRUCT        *d ;
  MEASUREITEMSTRUCT     *m ;
  static HBRUSH         hbr ;

  switch (message)
  {
    case WM_INITDIALOG :
         resize_listbox_dialog (hDlg, IDC_LISTBOX, 79) ;
         CenterWindowRelative ((HWND) lParam, hDlg, true, true) ;
         SetWindowText (hDlg, "POV-Ray Legal Statement [POVLEGAL.DOC]") ;
//       hbr = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;
         fill_listbox (GetDlgItem (hDlg, IDC_LISTBOX)) ;
         return (true) ;

    case WM_CTLCOLORBTN:
    case WM_CTLCOLORDLG:
    case WM_CTLCOLOREDIT:
    case WM_CTLCOLORLISTBOX:
    case WM_CTLCOLORSCROLLBAR:
    case WM_CTLCOLORSTATIC:
         return (DefWindowProc (hDlg, message, wParam, lParam)) ;

    case WM_COMMAND :
         switch (LOWORD (wParam))
         {
           case IDOK :
//              DeleteObject (hbr) ;
                EndDialog (hDlg, true) ;
                return (true) ;

           default :
                return (true) ;
         }

    case WM_MEASUREITEM :
         if (wParam == IDC_LISTBOX)
         {
           m = (MEASUREITEMSTRUCT *) lParam ;
           m->itemHeight = message_ychar ;
           return (true) ;
         }
         else
           return (false) ;

    case WM_DRAWITEM :
         if (wParam == IDC_LISTBOX)
         {
           d = (DRAWITEMSTRUCT *) lParam ;
           d->itemState &= ~ODS_SELECTED ;
           draw_ordinary_listbox (d, false) ;
           return (true) ;
         }
         else
           return (false) ;
  }
  return (false) ;
}

char *save_demo_file (char *s1, char *s2)
{
  char        **p = povdemo_scene ;
  FILE        *outF ;

  GetTempPath (_MAX_PATH - 16, s1) ;
  if (s1 [strlen (s1) - 1] != '\\')
    strcat (s1, "\\") ;
  strcpy (s2, s1) ;
  strcat (s1, "POVDEMO.$$1") ;
  strcat (s2, "POVDEMO.$$2") ;
  if ((outF = fopen (s1, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create temporary file", "Cannot run demo") ;
    return (NULL) ;
  }
  while (*p)
  {
    if (fprintf (outF, "%s\n", *p++) == EOF)
    {
      PovMessageBox ("Cannot write to temporary file", "Cannot run demo") ;
      fclose (outF) ;
      _unlink (s1) ;
      return (NULL) ;
    }
  }
  fclose (outF) ;
  p = povdemo_ini ;
  if ((outF = fopen (s2, "wt")) == NULL)
  {
    PovMessageBox ("Cannot create temporary file", "Cannot run demo") ;
    _unlink (s1) ;
    return (NULL) ;
  }
  while (*p)
  {
    if (fprintf (outF, "%s\n", *p++) == EOF)
    {
      PovMessageBox ("Cannot write to temporary file", "Cannot run demo") ;
      fclose (outF) ;
      _unlink (s1) ;
      _unlink (s2) ;
      return (NULL) ;
    }
  }
  fclose (outF) ;
  return (s1) ;
}

}
