/*******************************************************************************
 * povlangdef.h
 *
 * This file is part of the CodeMax editor support code.
 *
 * Author: Christopher J. Cason.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/windows/codemax/cmedit/povlangdef.h $
 * $Revision: #6 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

CM_LANGUAGE LangPOVRay =
{
  CMLS_PROCEDURAL,
  true,                 // case-sensitive flag
  NULL,                 // keywords; these are passed in from PVENGINE
  "+\n-\n*\n/\n=\n"     // operators
  "<\n>\n<=\n>=\n"
  "!=\n&\n|\n!\n"
  "?\n:",
  "//",                 // single line comment
  "/*",                 // multiline comment 1
  "*/",                 // multiline comment 2
  "{",                  // scope keywords 1
  "}",                  // scope keywords 2
  "\"",                 // string delimiters
  '\\',                 // escape character
  ';',                  // statement terminator
  NULL,
  NULL,
  NULL
} ;

CM_LANGUAGE LangINI =
{
  CMLS_PROCEDURAL,      // not really appropriate but works better than CMLS_SGML
  true,                 // case-sensitive flag
  "All_Console\n"       // TODO: get INI keywords from core
  "All_File\n"
  "Antialias_Depth\n"
  "Antialias\n"
  "Antialias_Threshold\n"
  "Bits_Per_Color\n"
  "Bits_Per_Colour\n"
  "Bounding\n"
  "Bounding_Method\n"
  "Bounding_Threshold\n"
  "BSP_BaseAccessCost\n"
  "BSP_ChildAccessCost\n"
  "BSP_ISectCost\n"
  "BSP_MaxDepth\n"
  "BSP_MissChance\n"
  "Buffer_Output\n"
  "Buffer_Size\n"
  "Clock\n"
  "Clockless_Animation\n"
  "Compression\n"
  "Continue_Trace\n"
  "Create_Histogram\n"
  "Create_Ini\n"
  "Cyclic_Animation\n"
  "Debug_Console\n"
  "Debug_File\n"
  "Declare\n"
  "Display\n"
  "Display_Gamma\n"
  "Draw_Vistas\n"
  "End_Column\n"
  "End_Row\n"
  "Fatal_Console\n"
  "Fatal_Error_Command\n"
  "Fatal_Error_Return\n"
  "Fatal_File\n"
  "Field_Render\n"
  "File_Gamma\n"
  "Final_Clock\n"
  "Final_Frame\n"
  "Height\n"
  "Histogram_Name\n"
  "Histogram_Grid_Size\n"
  "Histogram_Type\n"
  "Initial_Clock\n"
  "Initial_Frame\n"
  "Input_File_Name\n"
  "Include_Header\n"
  "Include_Ini\n"
  "Jitter_Amount\n"
  "Jitter\n"
  "Library_Path\n"
  "Light_Buffer\n"
  "Odd_Field\n"
  "Output_Alpha\n"
  "Output_File_Name\n"
  "Output_File_Type\n"
  "Output_To_File\n"
  "Palette\n"
  "Pause_When_Done\n"
  "Post_Frame_Command\n"
  "Post_Frame_Return\n"
  "Post_Scene_Command\n"
  "Post_Scene_Return\n"
  "Preview_End_Size\n"
  "Preview_Start_Size\n"
  "Pre_Frame_Command\n"
  "Pre_Frame_Return\n"
  "Pre_Scene_Command\n"
  "Pre_Scene_Return\n"
  "Quality\n"
  "Radiosity_File_Name\n"
  "Radiosity_From_File\n"
  "Radiosity_To_File\n"
  "Real_Time_Raytracing\n"
  "Remove_Bounds\n"
  "Render_Block_Size\n"
  "Render_Console\n"
  "Render_File\n"
  "Sampling_Method\n"
  "Split_Unions\n"
  "Start_Column\n"
  "Start_Row\n"
  "Statistic_Console\n"
  "Statistic_File\n"
  "Subset_End_Frame\n"
  "Subset_Start_Frame\n"
  "Test_Abort_Count\n"
  "Test_Abort\n"
  "User_Abort_Command\n"
  "User_Abort_Return\n"
  "Verbose\n"
  "Version\n"
  "Video_Mode\n"
  "Vista_Buffer\n"
  "Warning_Console\n"
  "Warning_File\n"
  "Warning_Level\n"
  "Width\n"
  "Work_Threads\n",
  "=\n",                // operators
  ";",                  // single line comment
  NULL,                 // multiline comment 1
  NULL,                 // multiline comment 2
  NULL,                 // scope keywords 1
  NULL,                 // scope keywords 2
  "\"",                 // string delimiters
  '\\',                 // escape character
  NULL,                 // statement terminator
  NULL,
  NULL,
  NULL
} ;

