/*******************************************************************************
 * msvc.h
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 2005-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/vfe/win/compilers/msvc.h $
 * $Revision: #9 $
 * $Change: 4539 $
 * $DateTime: 2008/02/09 02:03:26 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef __MSVC_H__
#define __MSVC_H__

#if _MSC_VER < 1400
  #error minimum Visual C++ version supported is 14.0 (supplied with VS 2005)
#endif

#include <direct.h>
#include <stdio.h>
#include <intrin.h>

#pragma auto_inline(on)
#pragma warning(disable : 4018) /* signed/unsigned mismatch */
#pragma warning(disable : 4305) /* truncation from 'type1' to 'type2' (mostly double to float) */
#pragma warning(disable : 4244) /* possible loss of data (converting ints to shorts) */

#ifdef __INTEL_COMPILER
  #pragma warning(disable : 1899) /* multicharacter character literal */

  #if __INTEL_COMPILER < 900
    #error minimum Intel C++ version supported is 9.0
  #endif

  #if __INTEL_COMPILER >= 900 && __INTEL_COMPILER < 1000
    #define COMPILER_VER                      ".icl9"
  #elif __INTEL_COMPILER >= 1000 && __INTEL_COMPILER < 1100
    #define COMPILER_VER                      ".icl10"
  #else
    #define COMPILER_VER                      ".icl"
  #endif
  #define COMPILER_NAME                       "Intel C++ Compiler"
  #define COMPILER_VERSION                    __INTEL_COMPILER
#else
  #pragma inline_recursion(on)
  #pragma inline_depth(255)

  #if _MSC_VER >= 1400 && _MSC_VER < 1500 && !defined (_WIN64)
    #define COMPILER_VER                      ".msvc8"
  #elif _MSC_VER >= 1400 && _MSC_VER < 1500 && defined (_WIN64)
    #define COMPILER_VER                      ".msvc8"
    #define ALIGN16                           __declspec(align(16))
    inline const int& max(const int& _X, const int& _Y) {return (_X < _Y ? _Y : _X); }
    inline const int& min(const int& _X, const int& _Y) {return (_Y < _X ? _Y : _X); }
    inline const unsigned int& max(const unsigned int& _X, const unsigned int& _Y) {return (_X < _Y ? _Y : _X); }
    inline const unsigned int& min(const unsigned int& _X, const unsigned int& _Y) {return (_Y < _X ? _Y : _X); }
    inline const long& max(const long& _X, const long& _Y) {return (_X < _Y ? _Y : _X); }
    inline const long& min(const long& _X, const long& _Y) {return (_Y < _X ? _Y : _X); }
    inline const unsigned long& max(const unsigned long& _X, const unsigned long& _Y) {return (_X < _Y ? _Y : _X); }
    inline const unsigned long& min(const unsigned long& _X, const unsigned long& _Y) {return (_Y < _X ? _Y : _X); }
  #else
    #define COMPILER_VER                      ".msvc"
  #endif
  #define COMPILER_NAME                       "Microsoft Visual C++"
  #define COMPILER_VERSION                    _MSC_VER

  #define NEED_INVHYP

  // boost will define these for us otherwise
  #ifdef NOT_USING_BOOST
    #if !defined (_WIN64)
      extern "C"
      {
        __declspec(dllimport) long __stdcall _InterlockedIncrement(long volatile *Addend);
        __declspec(dllimport) long __stdcall _InterlockedDecrement(long volatile *Addend);
        __declspec(dllimport) long __stdcall _InterlockedCompareExchange(long volatile *Dest, long Exchange, long Comp);
        __declspec(dllimport) long __stdcall _InterlockedExchange(long volatile *Target, long Value);
        __declspec(dllimport) long __stdcall _InterlockedExchangeAdd(long volatile *Addend, long Value);
      }

      #pragma intrinsic (_InterlockedCompareExchange)
      #define InterlockedCompareExchange _InterlockedCompareExchange

      #pragma intrinsic (_InterlockedExchange)
      #define InterlockedExchange _InterlockedExchange 

      #pragma intrinsic (_InterlockedExchangeAdd)
      #define InterlockedExchangeAdd _InterlockedExchangeAdd

      #pragma intrinsic (_InterlockedIncrement)
      #define InterlockedIncrement _InterlockedIncrement

      #pragma intrinsic (_InterlockedDecrement)
      #define InterlockedDecrement _InterlockedDecrement
    #endif
  #endif

#endif

#define QSORT(a,b,c,d)                      qsort((void *) a, (size_t) b, (size_t) c, (int (__cdecl*) (const void *, const void *)) d)
#define POV_LONG                            __int64
#define FORCEINLINE                         __forceinline

#undef ReturnAddress
#define ReturnAddress()                     _ReturnAddress()

#endif
