/*******************************************************************************
 * mingw32.h
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 2005-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/vfe/win/compilers/mingw32.h $
 * $Revision: #4 $
 * $Change: 4541 $
 * $DateTime: 2008/02/09 02:22:47 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

// NOTE: The POV-Ray developers have not tested version 3.7 with the mingw32 compiler.
// It is almost certain that there will be some issues. If you're happy to fix them
// then please go ahead and remove the #error below. Please do not report failure to
// build using this file as a bug - it is not a bug as we do not support this compiler.
//
// If you do get it working please consider contributing your changes back to the
// community.
//
// NB please also be aware that you will require a version of boost built for this
// compiler (at the very least, the boost headers and compiled boost::threads library).
#error Please read the comments in the source above this #error directive.

#include <stdio.h>    /* fseek and the like */
#include <algorithm>  /* min and max below */
using std::min;
using std::max;

// Note that this section is supposed to be compiled with MinGW 3.2 with GCC 3.2.3
// Old names (without underscores) are turned off there.

#if __MINGW32_MAJOR_VERSION == 3
  #define COMPILER_MAJOR_VER              "3"
#else
  #error "Adjust config.h to your compiler!"
#endif

#if __MINGW32_MINOR_VERSION == 1
  #define COMPILER_MINOR_VER              "1"
#else
  #error "Adjust config.h to your compiler!"
#endif

#if  __GNUC__ == 3
  #define GCC_MAJOR_VER                   "3"
#else
  #error "Adjust config.h to your compiler!"
#endif

#if __GNUC_MINOR__ == 2
  #define GCC_MINOR_VER                   "2"
#else
  #error "Adjust config.h to your compiler!"
#endif

#if __GNUC_PATCHLEVEL__ == 3
  #define GCC_PATCH_VER                   "3"
#else
  #error "Adjust config.h to your compiler!"
#endif

#define COMPILER_VER                      ".mingw-" COMPILER_MAJOR_VER \
                                          "." COMPILER_MINOR_VER \
                                          "(gcc-" GCC_MAJOR_VER \
                                          "." GCC_MINOR_VER \
                                          "." GCC_PATCH_VER ")"

#include <sys/stat.h>                     /* deliver stat structure/functions */
#define stat                              _stat
#define S_ISDIR(m)                        _S_ISDIR(m)
#define S_ISREG(m)                        _S_ISREG(m)

#include <math.h>                         /* deliver NAN */

#include <unistd.h>                       /* deliver _unlink definition */
#define DELETE_FILE(name)                 _unlink(name)
#define getcwd                            _getcwd

#include <windef.h>                       /* deliver BLOB from windef.h to dlgs.h */
#include <dlgs.h>                         /* deliver rad2 macro from dlgs.h */
#include <ctype.h>                        /* deliver toupper etc. */
#ifdef rad2                               /* undefine rad2 and leave name for field in blob.h */
  #undef rad2
#endif
#define NEED_INVHYP 1                     /* deliver asinh, acosh, atanh */

#ifndef MAX
  #define MAX(a,b) ((a>b)?a:b)
#endif
#ifndef MIN
  #define MIN(a,b) ((a>b)?b:a)
#endif

#ifndef fcloseall
  #define fcloseall                       _fcloseall
#endif

#define strnicmp                          _strnicmp
#define stricmp                           _stricmp
#define strlwr                            _strlwr
#define strupr                            _strupr
#define strdup                            _strdup


