/*******************************************************************************
 * radiositytask.cpp
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/source/backend/render/radiositytask.cpp $
 * $Revision: #14 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#include <boost/thread.hpp>
#include <boost/bind.hpp>

#include "base/types.h"
#include "base/timer.h"

#include "backend/frame.h"
#include "backend/render/radiositytask.h"
#include "backend/scene/threaddata.h"
#include "backend/scene/scene.h"
#include "backend/scene/view.h"

// this must be the last file included
#include "base/povdebug.h"

namespace pov
{

using namespace std;
using namespace boost;
using namespace pov_base;

RadiosityTask::RadiosityTask(ViewData *vd, int nt, int tn) :
	RenderTask(vd),
	trace(vd, GetViewDataPtr(), vd->GetSceneData()->parsedMaxTraceLevel, vd->GetSceneData()->parsedAdcBailout,
	      vd->GetQualityFeatureFlags(), cooperate, media, radiosity),
	pretraceStartSize(vd->GetSceneData()->parsedRadiositySettings.PretraceStart),
	pretraceEndSize(vd->GetSceneData()->parsedRadiositySettings.PretraceEnd),
	cooperate(*this),
	media(GetViewDataPtr(), &trace, &photonGatherer),
	radiosity(vd->GetSceneData(), GetViewDataPtr(),
	          vd->GetSceneData()->parsedMaxTraceLevel, vd->GetSceneData()->parsedAdcBailout,
	          vd->GetSceneData()->parsedRadiositySettings, vd->GetRadiosityCache(), cooperate, false),
	photonGatherer(&vd->GetSceneData()->surfacePhotonMap, vd->GetSceneData()->photonSettings),
	numThreads(nt),
	threadNum(tn)
{
}

RadiosityTask::~RadiosityTask()
{
}

// TODO: we probably want a radiosity task control thread rather that having each thread knowing
// its thread number and using this to work out its own pixel list. ideally this would be pre-
// computed once for all threads and passed to them, with the control thread co-ordinating the
// resulting data and sending stats etc. or something along those lines.
void RadiosityTask::Run()
{
	DBL maxWidthHeight = DBL(max(GetViewData()->GetWidth(), GetViewData()->GetHeight()));
	DBL startSize = floor(maxWidthHeight * clip(pretraceStartSize, 0.001, 1.0));
	DBL endSize = floor(maxWidthHeight * clip(pretraceEndSize, 0.001, 1.0));
	RandomIntSequence rands(0, 2, 2047);
	RandomIntSequence::Generator randgen(&rands);

	// this is necessary to avoid a infinite loop.
	startSize = max(startSize, 1.0);
	endSize = max(endSize, 1.0);

	// TODO FIXME - very bad way of computing this
	int pixels = 0; // total number of pixels for this thread only
	int curpixels = 0;
	DBL width = GetViewData()->GetWidth();
	DBL height = GetViewData()->GetHeight();

	if (threadNum == 0) // yes this is a hack, but it's only temporary
		for(DBL step = startSize; step >= endSize; step *= 0.5)
			for(DBL y = 0; y <= height; y += step)
				for(DBL x = step * threadNum; x <= width; x += step * numThreads)
					pixels++;

	POV_LONG nextProgress = 0; // send a progress report immediately
	for(DBL step = startSize; step >= endSize; step *= 0.5)
	{
		int offset = (step / 2) - 1;
		for(DBL y = 0; y <= height; y += step)
		{
			// TODO FIXME - better progress reporting and image preview
			if (threadNum == 0)
			{
				// for now, we send stats for the first thread only.
				// even though the total pixel count will be incorrect (it's for this thread only),
				// the ratio of pixels done to total pixels gives the user a good idea of progress,
				// which is a good start (even if it's not totally accurate).
				POV_LONG rt = ElapsedRealTime();
				if (rt >= nextProgress)
				{
					nextProgress = rt + 500; // at most, once per half-second
					POVMS_Object obj(kPOVObjectClass_RadiosityProgress);
					obj.SetLong(kPOVAttrib_RealTime, rt);
					obj.SetInt(kPOVAttrib_Pixels, pixels);
					obj.SetInt(kPOVAttrib_PixelsCompleted, curpixels);
					RenderBackend::SendViewOutput(GetViewData()->GetViewId(), GetSceneData()->frontendAddress, kPOVMsgIdent_Progress, obj);
				}
			}
			for(DBL x = step * threadNum; x <= width; x += step * numThreads)
			{
				Colour col;

				trace(x + offset + randgen(), y + offset + randgen(), GetViewData()->GetWidth(), GetViewData()->GetHeight(), col);
				GetViewDataPtr()->GetStatistics()[Number_Of_Pixels]++;

				Cooperate();

				curpixels++;
			}
		}
	}
}

void RadiosityTask::Stopped()
{
	 // nothing to do for now [trf]
}

void RadiosityTask::Finish()
{
	GetViewDataPtr()->timeType = SceneThreadData::kRadiosityTime;
	GetViewDataPtr()->realTime = ConsumedRealTime();
	GetViewDataPtr()->cpuTime = ConsumedCPUTime();
}

}
