/*******************************************************************************
 * pvmenu.cpp
 *
 * This module implements menu-related routines for the Windows build of POV.
 *
 * Author: Christopher J. Cason.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/windows/pvmenu.cpp $
 * $Revision: #22 $
 * $Change: 4537 $
 * $DateTime: 2008/02/09 01:25:49 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

// REMOVAL OF NON-EXPERT MENUS (August 1998) ... the 'non-expert menus' option
// was removed. This leaves some of this code redundant, but here it is anyhow ...

#define POVWIN_FILE
#define _WIN32_IE COMMONCTRL_VERSION
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <commctrl.h>
#include <setjmp.h>
#include <string.h>

#include "pvengine.h"
#include "resource.h"
#include "pvedit.h"
#include "pvdisplay.h"

#ifdef RTR_SUPPORT
  #include "rtrsupport.h"
#endif

// this must be the last file included
#include "syspovdebug.h"

namespace povwin
{

bool                    MenuBarDraw = false ;
char                    WindowList[MAX_EDITORS + 1][_MAX_PATH];
HMENU                   hMainMenu ;
HMENU                   hMenuBar ;
HMENU                   hPopupMenus ;
HMENU                   hFileMenu ;
HMENU                   hEditMenu ;
HMENU                   hRenderMenu ;
HMENU                   hOptionsMenu ;
HMENU                   hToolsMenu ;
HMENU                   hPluginsMenu ;
HMENU                   hHelpMenu ;
HMENU                   hOldRenderwinMenu ;
HMENU                   hNewRenderwinMenu ;
HMENU                   hVidcapMenu ;
HACCEL                  hAccelerators ;

extern HWND             main_window ;
extern HWND             toolbar_window ;
extern bool             Use2kXPRenderwin ;
extern bool             RenderwinIsChild ;
extern bool             preserve_bitmap ;
extern bool             rendering ;
extern bool             render_auto_close ;
extern unsigned         renderwin_8bits ;
extern HINSTANCE        hInstance ;

bool PVEnableMenuItem (UINT idItem, UINT state)
{
  EnableMenuItem (hPopupMenus, idItem, state) ;
  EnableMenuItem (hMenuBar, idItem, state) ;
  SendMessage (toolbar_window, TB_ENABLEBUTTON, idItem, MAKELONG (state == MF_ENABLED, 0)) ;
  if (idItem == CM_RENDERCLOSE)
  {
    SendMessage (toolbar_window, TB_HIDEBUTTON, CM_RENDERSHOW, MAKELONG (state == MF_ENABLED, 0)) ;
    SendMessage (toolbar_window, TB_HIDEBUTTON, CM_RENDERCLOSE, MAKELONG (state != MF_ENABLED, 0)) ;
  }
  return (true) ;
}

bool PVCheckMenuItem (UINT idItem, UINT state)
{
  CheckMenuItem (hPopupMenus, idItem, state) ;
  CheckMenuItem (hMenuBar, idItem, state) ;
  return (true) ;
}

bool PVCheckMenuRadioItem (UINT idFirst, UINT idLast, UINT idItem)
{
  CheckMenuRadioItem (hPopupMenus, idFirst, idLast, idItem, MF_BYCOMMAND) ;
  CheckMenuRadioItem (hMenuBar, idFirst, idLast, idItem, MF_BYCOMMAND) ;
  return (true) ;
}

bool PVModifyMenu (UINT idItem, UINT flags, UINT idNewItem, LPCSTR lpNewItem)
{
  ModifyMenu (hPopupMenus, idItem, flags, idNewItem, lpNewItem) ;
  ModifyMenu (hMenuBar, idItem, flags, idNewItem, lpNewItem) ;
  MenuBarDraw = true ;
  return (true) ;
}

bool PVDeleteMenuItem (UINT idItem)
{
  DeleteMenu (hPopupMenus, idItem, MF_BYCOMMAND) ;
  DeleteMenu (hMenuBar, idItem, MF_BYCOMMAND) ;
  return (true) ;
}

int find_menuitem (HMENU hMenu, LPCSTR title)
{
  int         max = GetMenuItemCount (hMenu) ;
  char        str [256] ;

  if (title[0] == '\0')
    return (-1);
  for (int i = 0 ; i < 64 ; i++)
    if (GetMenuString (hMenu, i, str, sizeof (str) - 1, MF_BYPOSITION) > 0)
      if (strcmp (title, str) == 0)
        return (i) ;
  return (-1) ;
}

void init_menus (void)
{
  hPopupMenus = LoadMenu (hInstance, MAKEINTRESOURCE (POPUP_MENUS32)) ;
  hAccelerators = LoadAccelerators (hInstance, MAKEINTRESOURCE (PVENGINE_MENU)) ;
  hMenuBar = LoadMenu (hInstance, MAKEINTRESOURCE (PVENGINE_MENU32)) ;
  hFileMenu = GetSubMenu (hMenuBar, 0) ;
  hEditMenu = GetSubMenu (hMenuBar, 1) ;
  hRenderMenu = GetSubMenu (hMenuBar, 2) ;
  hOptionsMenu = GetSubMenu (hMenuBar, 3) ;
  hToolsMenu = GetSubMenu (hMenuBar, 4) ;
  hHelpMenu = GetSubMenu (hMenuBar, 5) ;
  hOldRenderwinMenu = GetSubMenu (hPopupMenus, 2) ;
  hNewRenderwinMenu = GetSubMenu (hPopupMenus, 3) ;

  int n = find_menuitem(hOptionsMenu, "&Other Settings") ;
  assert(n != -1) ;
  hVidcapMenu = GetSubMenu(GetSubMenu(hOptionsMenu, n), 0) ;

  n = find_menuitem(hOptionsMenu, "GU&I-Extensions") ;
  assert(n != -1) ;
  hPluginsMenu = GetSubMenu(hOptionsMenu, n);
}

void set_newuser_menu (HMENU hMenu, UINT ID, bool hide, bool separator)
{
  if (GetMenuItemID (hMenu, 0) != ID)
  {
    if (hide)
      return ;
    if (separator)
      InsertMenu (hMenu, 0, MF_BYPOSITION | MF_SEPARATOR, 0, NULL) ;
    InsertMenu (hMenu, 0, MF_BYPOSITION, ID, "&Help On This Menu") ;
  }
  else
  {
    if (!hide)
      return ;
    DeleteMenu (hMenu, 0, MF_BYPOSITION) ;
    if (separator)
      DeleteMenu (hMenu, 0, MF_BYPOSITION) ;
  }
}

void set_newuser_menus (bool hide)
{
  set_newuser_menu (hFileMenu, CM_FILEMENUHELP, hide, true) ;
  set_newuser_menu (hEditMenu, CM_EDITMENUHELP, hide, true) ;
  set_newuser_menu (hRenderMenu, CM_RENDERMENUHELP, hide, true) ;
  set_newuser_menu (hOptionsMenu, CM_OPTIONSMENUHELP, hide, true) ;
  set_newuser_menu (hToolsMenu, CM_TOOLSMENUHELP, hide, false) ;
  set_newuser_menu (hPluginsMenu, CM_GUIEXTMENUHELP, hide, true) ;
  set_newuser_menu (GetSubMenu (hPopupMenus, 0), CM_MESSAGEWINMENUHELP, hide, true) ;
  set_newuser_menu (GetSubMenu (hPopupMenus, 1), CM_RENDERWINMENUHELP, hide, true) ;
  EditPassOnMessage (NULL, HIDE_NEWUSER_HELP_MESSAGE, hide, 0, NULL) ;
}

void clear_menu (HMENU hMenu)
{
  while (RemoveMenu (hMenu, 0, MF_BYPOSITION)) ;
}

void setup_menus (bool have_editor)
{
#ifdef INCLUDE_NEW_LAYERED_WINDOW
  AppendMenu (hOptionsMenu, MF_POPUP, (UINT_PTR) (Use2kXPRenderwin ? hNewRenderwinMenu : hOldRenderwinMenu), "&Render Window") ;
#endif
  if (have_editor)
    AppendMenu (hOptionsMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetOptionsMenu), "&Editor Window") ;

#ifdef RTR_SUPPORT
  std::vector<std::string> vidSources;
  size_t numSources = GetVideoSourceNames(vidSources);
  if (numSources > 0)
  {
    DeleteMenu (hVidcapMenu, 0, MF_BYPOSITION) ;
    if (numSources > CM_LASTVIDEOSOURCE - CM_FIRSTVIDEOSOURCE + 1)
      numSources = CM_LASTVIDEOSOURCE - CM_FIRSTVIDEOSOURCE + 1 ;
    for (int i = 0; i < numSources; i++)
      InsertMenu (hVidcapMenu, -1, MF_BYPOSITION, CM_FIRSTVIDEOSOURCE + i, vidSources[i].c_str()) ;
    CheckMenuRadioItem(hVidcapMenu, CM_FIRSTVIDEOSOURCE, CM_LASTVIDEOSOURCE, CM_FIRSTVIDEOSOURCE, MF_BYCOMMAND);
    int n = find_menuitem (hVidcapMenu, GetVideoSourceName().c_str());
    if (n != -1)
      CheckMenuRadioItem(hVidcapMenu, CM_FIRSTVIDEOSOURCE, CM_LASTVIDEOSOURCE, CM_FIRSTVIDEOSOURCE + n, MF_BYCOMMAND);
    else
      SetVideoSourceName(vidSources[0].c_str());
  }
#endif

  DrawMenuBar (main_window) ;
}

#ifdef INCLUDE_NEW_LAYERED_WINDOW
void swap_renderwin_menu (void)
{
  int index = find_menuitem (hOptionsMenu, "&Render Window") ;
  if (index >= 0)
  {
    RemoveMenu (hOptionsMenu, index, MF_BYPOSITION) ;
    InsertMenu (hOptionsMenu, index, MF_BYPOSITION | MF_POPUP, (UINT_PTR) (Use2kXPRenderwin ? hNewRenderwinMenu : hOldRenderwinMenu), "&Render Window") ;
    CheckMenuItem (hOptionsMenu, CM_USE2KXPRENDERWIN, Use2kXPRenderwin ? MF_CHECKED : MF_UNCHECKED) ;
    CheckMenuItem (hOptionsMenu, CM_RENDERABOVEMAIN, RenderwinIsChild ? MF_CHECKED : MF_UNCHECKED) ;
    EnableMenuItem (hOptionsMenu, CM_RENDERHIDE, RenderwinIsChild ? MF_GRAYED : MF_ENABLED) ;
    EnableMenuItem (hOptionsMenu, CM_RENDERACTIVE, RenderwinIsChild ? MF_GRAYED : MF_ENABLED) ;
    CheckMenuItem (hOptionsMenu, CM_PRESERVERENDERBITMAP, preserve_bitmap ? MF_CHECKED : MF_UNCHECKED) ;
    EnableMenuItem (hOptionsMenu, CM_FORCE8BITS, rendering ? MF_GRAYED : MF_ENABLED) ;
    CheckMenuItem (hOptionsMenu, CM_FORCE8BITS, renderwin_8bits ? MF_CHECKED : MF_UNCHECKED) ;
    CheckMenuItem (hOptionsMenu, CM_RENDERAUTOCLOSE, render_auto_close ? MF_CHECKED : MF_UNCHECKED) ;
    if (pov_frontend::GetRenderWindow())
    {
      if (pov_frontend::GetRenderWindow()->IsVisible())
      {
        PVEnableMenuItem (CM_RENDERSHOW, MF_GRAYED) ;
        PVEnableMenuItem (CM_RENDERCLOSE, MF_ENABLED) ;
      }
      else
      {
        PVEnableMenuItem (CM_RENDERSHOW, MF_ENABLED) ;
        PVEnableMenuItem (CM_RENDERCLOSE, MF_GRAYED) ;
      }
    }
    else
    {
      PVEnableMenuItem (CM_RENDERSHOW, MF_GRAYED) ;
      PVEnableMenuItem (CM_RENDERCLOSE, MF_GRAYED) ;
    }
    DrawMenuBar (main_window) ;
  }
}
#endif

// build the menu displayed when the message window is selected
void build_main_menu (HMENU hMenu, bool have_editor)
{
  clear_menu (hMenu) ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) (have_editor ? EditGetMenu (GetFileMenu) : hFileMenu), "&File") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hEditMenu, "&Edit") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hRenderMenu, "&Render") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hOptionsMenu, "&Options") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hToolsMenu, "&Tools") ;
  if (EditGetMenu (GetWindowMenu) != NULL)
    AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetWindowMenu), "&Window") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hHelpMenu, "&Help") ;
  DrawMenuBar (main_window) ;
}

// build the menu displayed when an editor window is selected
void build_editor_menu (HMENU hMenu)
{
  clear_menu (hMenu) ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetFileMenu), "&File") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetEditMenu), "&Edit") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetSearchMenu), "Se&arch") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetTextMenu), "&Text") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetOptionsMenu), "E&ditor") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetInsertMenu), "&Insert") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hRenderMenu, "&Render") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hOptionsMenu, "&Options") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hToolsMenu, "Too&ls") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) EditGetMenu (GetWindowMenu), "&Window") ;
  AppendMenu (hMenu, MF_POPUP, (UINT_PTR) hHelpMenu, "&Help") ;
  DrawMenuBar (main_window) ;
}

}
