/*******************************************************************************
 * trace.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/source/backend/render/trace.h $
 * $Revision: #60 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef POVRAY_BACKEND_TRACE_H
#define POVRAY_BACKEND_TRACE_H

#include <vector>

#include <boost/thread.hpp>
#include <boost/shared_ptr.hpp>

#include "backend/frame.h"
#include "backend/povray.h"
#include "backend/scene/atmosph.h"
#include "backend/scene/threaddata.h"
#include "backend/scene/objects.h"
#include "backend/support/bsptree.h"
#include "povrayold.h"

namespace pov
{

using namespace std;
using namespace boost;

class SceneData;
class ViewData;
class Task;
class PhotonGatherer;

struct NoSomethingFlagRayObjectCondition : public RayObjectCondition
{
	virtual bool operator()(Ray& ray, ObjectPtr object) const
	{
		if(ray.IsPrimaryRay() && Test_Flag(object, NO_IMAGE_FLAG))
			return false;
		if(ray.IsReflectionRay() && Test_Flag(object, NO_REFLECTION_FLAG))
			return false;
		return true;
	}
};

struct LitInterval
{
	bool lit;
	DBL s0, s1, ds;
	size_t l0, l1;

	LitInterval() :
		lit(false), s0(0.0), s1(0.0), ds(0.0), l0(0), l1(0) { }
	LitInterval(bool nlit, DBL ns0, DBL ns1, size_t nl0, size_t nl1) :
		lit(nlit), s0(ns0), s1(ns1), ds(ns1 - ns0), l0(nl0), l1(nl1) { }
};

struct MediaInterval
{
	bool lit;
	int samples;
	DBL s0, s1, ds;
	size_t l0, l1;
	Colour od;
	Colour te;
	Colour te2;

	MediaInterval() :
		lit(false), samples(0), s0(0.0), s1(0.0), ds(0.0), l0(0), l1(0) { }
	MediaInterval(bool nlit, int nsamples, DBL ns0, DBL ns1, DBL nds, size_t nl0, size_t nl1) :
		lit(nlit), samples(nsamples), s0(ns0), s1(ns1), ds(nds), l0(nl0), l1(nl1) { }
	MediaInterval(bool nlit, int nsamples, DBL ns0, DBL ns1, DBL nds, size_t nl0, size_t nl1, const Colour& nod, const Colour& nte, const Colour& nte2) :
		lit(nlit), samples(nsamples), s0(ns0), s1(ns1), ds(nds), l0(nl0), l1(nl1), od(nod), te(nte), te2(nte2) { }

	bool operator<(const MediaInterval& other) const { return (s0 < other.s0); }
};

struct LightSourceIntersectionEntry
{
	DBL s;
	size_t l;
	bool lit;

	LightSourceIntersectionEntry() :
		s(0.0), l(0), lit(false) { }
	LightSourceIntersectionEntry(DBL ns, size_t nl, bool nlit) :
		s(ns), l(nl), lit(nlit) { }

	bool operator<(const LightSourceIntersectionEntry& other) const { return (s < other.s); }
};

struct LightSourceEntry
{
	DBL s0, s1;
	LightSource *light;

	LightSourceEntry() :
		s0(0.0), s1(0.0), light(NULL) { }
	LightSourceEntry(LightSource *nlight) :
		s0(0.0), s1(0.0), light(nlight) { }
	LightSourceEntry(DBL ns0, DBL ns1, LightSource *nlight) :
		s0(ns0), s1(ns1), light(nlight) { }

	bool operator<(const LightSourceEntry& other) const { return (s0 < other.s0); }
};

// TODO: these sizes will need tweaking.
typedef FixedSimpleVector<Media *, 64> MediaVector; // TODO FIXME - cannot allow this to be fixed size [trf]
typedef FixedSimpleVector<MediaInterval, 64> MediaIntervalVector; // TODO FIXME - cannot allow this to be fixed size [trf]
typedef FixedSimpleVector<LitInterval, 64> LitIntervalVector; // TODO FIXME - cannot allow this to be fixed size [trf]
typedef FixedSimpleVector<LightSourceIntersectionEntry, 64> LightSourceIntersectionVector; // TODO FIXME - cannot allow this to be fixed size [trf]
typedef FixedSimpleVector<LightSourceEntry, 64> LightSourceEntryVector; // TODO FIXME - cannot allow this to be fixed size [trf]

class Trace
{
	public:
		class CooperateFunctor
		{
			public:
				virtual void operator()() { }
		};

		class MediaFunctor
		{
			public:
				virtual void ComputeMedia(vector<Media>&, Ray&, Intersection&, Colour&) { }
				virtual void ComputeMedia(const RayInteriorVector&, Ray&, Intersection&, Colour&) { }
				virtual void ComputeShadowMedia(Ray&, Intersection&, Colour&) { }
				virtual void ComputeMedia(MediaVector&, Ray&, Intersection&, Colour&) { }
		};

		class RadiosityFunctor
		{
			public:
				virtual void ComputeAmbient(const Ray&, const Vector3d&, const Vector3d&, Vector3d, RGBColour&, DBL) { }
				virtual bool CheckRadiosityTraceLevel() { return false; }
		};

		Trace(shared_ptr<SceneData> sd, TraceThreadData *td, unsigned int mtl, DBL adcb, unsigned int qf,
		      CooperateFunctor& cf, MediaFunctor& mf, RadiosityFunctor& af);
		~Trace();

		virtual DBL TraceRay(Ray& ray, Colour& colour, COLC weight);

		bool FindIntersection(Intersection& isect, Ray& ray);
		bool FindIntersection(Intersection& isect, Ray& ray, const RayObjectCondition& precondition, const RayObjectCondition& postcondition);
		bool FindIntersection(ObjectPtr object, Intersection& isect, Ray& ray, DBL closest = HUGE_VAL);

		unsigned int GetCurrentTraceLevel();
		unsigned int GetHighestTraceLevel();

		DBL GetADCBailout() { return adcBailout; }

		bool TestShadow(LightSource *light, DBL& depth, Ray& light_source_ray, Ray& eyeray, Vector3d& p, Colour& colour); // TODO FIXME - this shoudl not be exposed here
	protected: // TODO FIXME - should be private
		struct WNRX
		{
			DBL weight;
			Vector3d normal;
			Colour reflec;
			SNGL reflex;

			WNRX(DBL w, const Vector3d& n, const Colour& r, SNGL x) :
				weight(w), normal(n), reflec(r), reflex(x) { }
		};

		typedef vector<TEXTURE *> TextureVectorData;
		typedef RefPool<TextureVectorData> TextureVectorPool;
		typedef Ref<TextureVectorData, RefClearContainer<TextureVectorData> > TextureVector;

		typedef vector<WNRX> WNRXVectorData;
		typedef RefPool<WNRXVectorData> WNRXVectorPool;
		typedef Ref<WNRXVectorData, RefClearContainer<WNRXVectorData> > WNRXVector;

		/// scene data
		shared_ptr<SceneData> sceneData;

		/// trace recursion level
		unsigned int traceLevel;
		/// maximum trace recursion level allowed
		unsigned int maxAllowedTraceLevel;
		/// maximum trace recursion level found
		unsigned int maxFoundTraceLevel;
		/// adc bailout
		DBL adcBailout;
		/// render quality feature flags
		unsigned int qualityFlags; 

		/// bounding slabs priority queue
		PriorityQueue priorityQueue;
		/// BSP tree mailbox
		BSPTree::Mailbox mailbox;
		/// area light grid buffer
		vector<Colour> lightGrid;
		/// fast stack pool
		IStackPool stackPool;
		/// fast texture list pool
		TextureVectorPool texturePool;
		/// fast WNRX list pool
		WNRXVectorPool wnrxPool;
		/// light source shadow cache for shadow tests of first trace level intersections
		vector<ObjectPtr> lightSourceLevel1ShadowCache;
		/// light source shadow cache for shadow tests of higher trace level intersections
		vector<ObjectPtr> lightSourceOtherShadowCache;
		/// pseudo-random number sequence
		RandomDoubleSequence randomNumbers;
		/// pseudo-random number generator based on random number sequence
		RandomDoubleSequence::Generator randomNumberGenerator;
		/// thread data
		TraceThreadData *threadData;
	
		CooperateFunctor& cooperate;
		MediaFunctor& media;
		RadiosityFunctor& radiosity;

		void ComputeTextureColour(Intersection& isect, Colour& colour, Ray& ray, COLC weight, bool photonpass);
		void ComputeOneTextureColour(Colour& resultcolour, TEXTURE *texture, vector<TEXTURE *>& warps, Vector3d& ipoint,
		                             Vector3d& rawnormal, Ray& ray, COLC weight, Intersection& isect, bool shadowflag, bool photonpass);
		void ComputeAverageTextureColours(Colour& resultcolour, TEXTURE *texture, vector<TEXTURE *>& warps, Vector3d& ipoint,
		                                  Vector3d& rawnormal, Ray& ray, COLC weight, Intersection& isect, bool shadowflag, bool photonpass);

		virtual void ComputeLightedTexture(Colour& resultcolour, TEXTURE *texture, vector<TEXTURE *>& warps, Vector3d& ipoint,
		                                   Vector3d& rawnormal, Ray& ray, COLC weight, Intersection& isect);
	
		void ComputeShadowTexture(Colour& filtercolour, TEXTURE *texture, vector<TEXTURE *>& warps, Vector3d& ipoint,
		                          Vector3d& rawnormal, Ray& ray, Intersection& isect);

		void ComputeReflection(Vector3d& ipoint, Ray& ray, Vector3d& normal, Vector3d& rawnormal, Colour& colour, COLC weight);

		bool ComputeRefraction(Interior *interior, Vector3d& ipoint, Ray& ray, Vector3d& normal, Vector3d& rawnormal, Colour& colour, COLC weight);
		bool TraceRefractionRay(Vector3d& ipoint, Ray& ray, Ray& nray, DBL ior, DBL n, Vector3d& normal, Vector3d& rawnormal, Vector3d& localnormal, Colour& colour, COLC weight);

		void ComputeDispersion(RGBColour& hue, unsigned int elem, unsigned int nelems);
		DBL ComputeDispersionFactor(DBL disp, unsigned int elem, unsigned int nelems);

		void ComputeDiffuseLight(FINISH *linish, Vector3d& ipoint, Ray& eye, Vector3d& layer_normal, Colour& layer_pigment_colour,
		                         Colour& colour, DBL attenuation, ObjectPtr object);
		void ComputePhotonDiffuseLight(FINISH *Finish, Vector3d& IPoint, Ray& Eye,  Vector3d&  Layer_Normal,  Vector3d& Raw_Normal, Colour& Layer_Pigment_Colour, Colour& colour, DBL Attenuation, ObjectPtr Object, PhotonGatherer& renderer);
		void ComputeOneDiffuseLight(LightSource *lightsource, Vector3d& reye, FINISH *finish, Vector3d& ipoint, Ray& eye,
		                            Vector3d& layer_normal, Colour& Layer_Pigment_Colour, Colour& colour, DBL Attenuation, ObjectPtr Object);
                void ComputeFullAreaDiffuseLight(LightSource *lightsource, Vector3d& reye, FINISH *finish, Vector3d& ipoint, Ray& eye,
                                                 Vector3d& layer_normal, Colour& layer_pigment_colour, Colour& colour, DBL attenuation,
                                                 DBL lightsourcedepth, Ray& lightsourceray, Colour& lightcolour,
                                                 bool isDoubleIlluminated); // JN2007: Full area lighting
		void ComputeOneLightRay(LightSource *lightsource, DBL& lightsourcedepth, Ray& lightsourceray, Ray& eyeray, Vector3d& ipoint, Colour& lightcolour);
		void TraceShadowRay(LightSource *light, DBL depth, Ray& lightsourceray, Ray& eyeray, Vector3d& point, Colour& colour);
		void TracePointLightShadowRay(LightSource *lightsource, DBL& lightsourcedepth, Ray& lightsourceray, Colour& lightcolour);
		void TraceAreaLightShadowRay(LightSource *lightsource, DBL& lightsourcedepth, Ray& lightsourceray, Ray& eyeray,
		                             Vector3d& ipoint, Colour& lightcolour, int u1, int  v1, int  u2, int  v2, int level);
		void ComputeShadowColour(LightSource *lightsource, Intersection& isect, Ray& lightsourceray, Colour& colour);
		void ComputeDiffuseColour(FINISH *finish, Ray& lightsourceray, Vector3d& layer_normal, Colour& colour, Colour& light_colour, Colour& layer_pigment_colour, DBL attenuation);
		void ComputeIridColour(FINISH *finish, Ray& lightsourceray, Vector3d& layer_normal, Vector3d& ipoint, Colour& colour);
		void ComputePhongColour(FINISH *finish, Ray& lightsourceray, Vector3d& eye, Vector3d& layer_normal, Colour& colour, Colour& light_colour, Colour& layer_pigment_colour);
		void ComputeSpecularColour(FINISH *finish, Ray& lightsourceray, Vector3d& eye, Vector3d& layer_normal, Colour& colour, Colour& light_colour, Colour& layer_pigment_colour);
		void ComputeReflectivity(DBL& weight, Colour& reflectivity, const Colour& reflection_max, const Colour& reflection_min,
		                         int reflection_type, DBL reflection_falloff, DBL cos_angle, Ray& ray, Interior *interior);
		void ExtractedFromAreaLightCodeMegaPOVMess(LightSource *lightsource, DBL& lightsourcedepth, Ray& lightsourceray, Ray& eyeray, Vector3d& ipoint, const Vector3d& center);
		void ComputeSky(Ray& ray, Colour& colour);
		void ComputeFog(Ray& ray, Intersection& isect, Colour& colour);
		DBL ComputerConstantFogColour(Ray &ray, DBL depth, DBL width, FOG *fog, Colour& colour);
		DBL ComputeGroundFogColour(Ray& ray, DBL depth, DBL width, FOG *fog, Colour& colour);
		void ComputeRainbow(Ray& ray, Intersection& isect, Colour& colour);
		void ComputeShadowMedia(Ray& light_source_ray, Intersection& isect, Colour& resultcolour, bool media_attenuation_and_interaction);
		bool IsObjectInCSG(ObjectPtr object, ObjectPtr parent);
};

}

#endif // POVRAY_BACKEND_TRACE_H
