#declare iftest = on;
#declare aR = 0.02;

global_settings {
   max_trace_level 100
}

#declare top =
camera {
   location <0, 30, 0>
   look_at <0, 0, 0>
   //angle 160
   angle 30
}

#declare spot =
camera {
   location <-2.5, 0.25, -1.5>
   look_at <-2.0, 0.25, -1>
   angle 45
}

#declare rspot =
camera {
   location <1, 0.25, 1.5>
   look_at <-1, 0.25, 0>
   angle 45
}

camera { spot }

light_source {
   <10, 10, 10>
   color <1, 1, 1>*1
   shadowless
}

plane { // ground plane
   y, 0
   texture {
      pigment {
	 checker rgb <1, 1, 1>, <0.5, 0.5, 0.5>
	 scale 0.5
      }
      finish {
	 ambient aR
	 diffuse 0.8
      }
   }
}

#if(iftest) // interface test
   //merge {
   union {
#end
      intersection { // glas test object
	 box {
	    <-2.0, 0.01, -1>, <2.0, 0.5, 0>
	 }
	 plane {
	    -x, 0
	    rotate -45*y
	    translate -2.5*x
	 }
	 plane {
	    x, 0
	    rotate 45*y
	    translate 2.5*x
	 }

	 texture {
	    pigment {
	       color rgbf <0.8, 0.8, 1, 0.95>
	    }
	    finish {
	       ambient 0
	       diffuse 0
	       reflection {
		  0, 1
		  fresnel
	       }
	       conserve_energy
	    }
	 }
	 interior {
	    ior 1.5
	 }
      }

#if(iftest) // interface test
      // interface type:
      //    -0.01 small intersection
      //     0.01 small gap
      //    -0.40 large intersection
      #declare i = -0.01;
      prism {
	 0.02, 0.501, 3
	 <-1.5, 0>, <1.5, 0>, <-1.5, 4>
	 translate z*i
	 texture {
	    pigment {
	       color rgbf <1, 1, 0.8, 0.95>
	    }
	    finish {
	       ambient 0
	       diffuse 0
	       reflection {
		  0, 1
		  fresnel
	       }
	       conserve_energy
	    }
	 }
	 interior {
	    ior 1.33
	 }
      }
   }
#end

#declare radiusG = 100;
#declare sizeG = 2;
#declare stepG = 5;
#declare r = 0;
#while(r < 360)
   #declare txt =
   text {
      #declare rStr = str(r, 3, 0);
      ttf "/home/kai/.fonts/verdanab.ttf" rStr
      0.2, 0
   }

   object { txt
      #declare c = 0.5*(min_extent(txt) + max_extent(txt));
      translate -x * c.x
      scale sizeG
      translate <0, 0.5, radiusG>
      rotate r*y

      texture {
	 pigment {
	    color <1, 1, 0.5>
	 }
	 finish {
	    ambient 1.0
	    diffuse 0.
	 }
      }
   }

   sphere {
      <0, 0, 0>, sizeG*0.1
      translate <0, 0.25, radiusG>
      rotate r*y

      texture {
	 pigment {
	    color <1, 1, 0.5>
	 }
	 finish {
	    ambient 1.0
	    diffuse 0.
	 }
      }
   }

   #declare r = r + stepG;
#end
