#version 3.6;
#include "colors.inc"

global_settings {
	max_trace_level 30
}

#declare metalfin = finish {
	ambient 0.3
	diffuse 0.2
	specular 1.0
	roughness 0.06
}

#declare v_texture = texture {
	pigment { rgb<.25,0,.25> }
	finish { metalfin }
}

#declare e_texture = texture {
	pigment { White/2 }
	finish { metalfin }
}

#local lookat = <0,0,0>;
#local base_lookfrom = <0.1, 0.2, -0.8>;
#local lookfrom = base_lookfrom*.6;

camera {
	location lookfrom
	look_at lookat

	// Fix aspect ratio for square image (use output width/output height)
	right x*1.0/1.0
}

light_source { <200, 80, -100>, White }
light_source { <0, -80, 40>, White*.3 }

background { White }

// Ridges
mesh2 {
	vertex_vectors {
		5,
		// 24
		<0.03249196962329062993, -0.05257311121191336062, -0.19021130325903071179>,
		// 72
		<0.08792183440801312755, -0.05433868201739210785, -0.17584366881602625510>,
		// 77
		<0.05433868201739210785, 0.00000000000000000000, -0.19659919844279735712>,
		// 128
		<0.03429496250085656284, -0.08978537747014557480, -0.17957075494029114959>,
		// 133
		<0.00000000000000000000, -0.03429496250085656284, -0.20076620740872361259>,
	}
	texture_list {
		1,
		texture { pigment { rgb<1,0,0> transmit 0.5 } finish { ambient 0.5 } }
	}
	face_indices {
		6,
		<0, 1, 2>, 0	// Ridge 1521
		<0, 1, 3>, 0	// Ridge 1522
		<0, 2, 4>, 0	// Ridge 1523
		<0, 3, 4>, 0	// Ridge 1524
		<1, 2, 4>, 0,  <1, 4, 3>, 0	// Ridge 1732
	}
	transform { rotate z*60 scale 1.3 }
}

// Edge 1297
cone {
	<0.03249196962329062993, -0.05257311121191336062, -0.19021130325903071179>, 9.80580675690920309379e-04
	<0.08792183440801312755, -0.05433868201739210785, -0.17584366881602625510>, 1.01273102597786851531e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1298
cone {
	<0.03249196962329062993, -0.05257311121191336062, -0.19021130325903071179>, 9.80580675690920309379e-04
	<0.05433868201739210785, 0.00000000000000000000, -0.19659919844279735712>, 1.01273102597786851531e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1299
cone {
	<0.03249196962329062993, -0.05257311121191336062, -0.19021130325903071179>, 9.80580675690920309379e-04
	<0.03429496250085656284, -0.08978537747014557480, -0.17957075494029114959>, 1.03425625558880543604e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1300
cone {
	<0.03249196962329062993, -0.05257311121191336062, -0.19021130325903071179>, 9.80580675690920309379e-04
	<0.00000000000000000000, -0.03429496250085656284, -0.20076620740872361259>, 1.03425625558880543604e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1488
cone {
	<0.08792183440801312755, -0.05433868201739210785, -0.17584366881602625510>, 1.01273102597786851531e-03
	<0.05433868201739210785, 0.00000000000000000000, -0.19659919844279735712>, 1.01273102597786851531e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1490
cone {
	<0.08792183440801312755, -0.05433868201739210785, -0.17584366881602625510>, 1.01273102597786851531e-03
	<0.03429496250085656284, -0.08978537747014557480, -0.17957075494029114959>, 1.03425625558880543604e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1509
cone {
	<0.05433868201739210785, 0.00000000000000000000, -0.19659919844279735712>, 1.01273102597786851531e-03
	<0.00000000000000000000, -0.03429496250085656284, -0.20076620740872361259>, 1.03425625558880543604e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
// Edge 1709
cone {
	<0.03429496250085656284, -0.08978537747014557480, -0.17957075494029114959>, 1.03425625558880543604e-03
	<0.00000000000000000000, -0.03429496250085656284, -0.20076620740872361259>, 1.03425625558880543604e-03
	texture { e_texture }
	transform { rotate z*60 scale 1.3 }
	no_shadow
}
