#version 3.7;

// -- Variables and setup

// -- Work Area
#declare UseGrid = no;
#declare WorkMode = yes;

// -- Scene Complexity
#declare Detail = no;
#declare DoObjects = no;
#declare TestObject = no;

// -- Lighting Types
#declare UseLight = yes;
#declare AreaLight = no;
#declare SpotLight = no;
#declare ParaLight = no;
#declare FocalBlur = no;

// 0=no rad, 1=load, 2=save

#default { finish { ambient 0 emission 0 diffuse 0.6}}

#declare _scale = 254;

//If you model using 1 cm per unit, set to 10 (default)
//If you model using 1 inch per unit, set it to 25.4.
//If you model using 1 unit = 1m, set it to 1000.

#declare Quality = 0;

#if (Quality > 0)
  #declare UsePhotons = yes;
  #declare PhotonRun = no; // change to "no" to reuse a map
#end

#switch (Quality)
  #case (0)
    #declare UsePhotons = no;
  #break
  #case (1)
    #declare S_val = 0.1;
    #declare M_val = 75;
    #declare T_val = 5;
  #break
  #case (2)
    #declare S_val = 0.025;
    #declare M_val = 150;
    #declare T_val = 10;
  #break
  #case (3)
    #declare S_val = 0.004;
    #declare M_val = 300;
    #declare T_val = 15;
  #break
#end
 
global_settings {
	max_trace_level 80
	noise_generator 3
	assumed_gamma 1.0
	mm_per_unit _scale
	subsurface {}
	#if (UseRad)
		radiosity {
			#if (UseRad=2)
				pretrace_start 0.08
				pretrace_end   0.008
				nearest_count 10
				count 150
				gray_threshold 0
				error_bound 0.5
				recursion_limit 3
				low_error_factor 0.5
				minimum_reuse 0.005
				maximum_reuse 0.2
				//max_sample 0.95
				normal on
			#else
				pretrace_start 1
				pretrace_end 1
				gray_threshold 0
				nearest_count 10
				always_sample off
		  #end
			}
	#end
	#if(UsePhotons)
    photons {
      spacing S_val
      media M_val
      autostop 0
      max_trace_level T_val
      #if (PhotonRun)
        save_file "/povfiles/Compass.ph"
      #else
        load_file "/povfiles/Compass.ph"
      #end
      }
  #end
	}

// -- Some Includes
#include "colors.inc"
//#include "grid.inc"
//#include "functions.inc"
//#include "stones.inc"
//#include "golds.inc"
//#include "finish.inc"
//#include "Table.inc"
//#include "metals.inc"

/*#declare Table =
	box {<1,0,1>, <-1,5,-1> pigment {rgb 1}};*/

/*#declare bingo = <0,0,0>;
#declare tabletop = trace (Table, <0,10,0>, <0,-1,0>, bingo);
#declare tabletop = tabletop + <0,0.001,0>;

#if (vlength(bingo) = 0)
	#debug "\n no vector returned from trace \n"
#end*/

#if (UseGrid)
	object {grid scale 1 }//translate tabletop}
#end

#if (WorkMode)
	#declare CamPos = <0,0,-10>;
	#declare LookAt = <0,0,0>;
	#declare ZF = 1*z;
#else
	#declare CamPos = <0, 1, -1>;
	#declare LookAt = <0,1,0>;
	#declare ZF = 1*z;
#end

// -- Camera & Lighting
camera {
	perspective
	location CamPos
	look_at  LookAt
	#if (FocalBlur)
		aperture 0.15
		blur_samples 64, 128
		confidence 0.9
		variance 1/5000
		focal_point <0,0,0>
	#end
	#if (WorkMode)
		rotate x*8
		rotate y*-5
	#else
		rotate x*0
		rotate y*40
	#end
	right  x*4/3
	direction ZF
	//angle 36
	}

#declare LightPos = <0,0,-25>;
#declare LightDist = vlength(LightPos);

// --- Main Light
#if (UseLight)
light_source {
 	0,rgb 5
	//#if (!WorkMode)
		//looks_like {sphere {0,1 pigment {rgb 1}} finish {emission 1 diffuse 0}}
	//#end
	#if (ParaLight)
		parallel
	#end
	#if (SpotLight)
		spotlight
	#end
	#if (AreaLight)
		//As a rule of thumb, fade_distance of an area light source should be about
		//the same order of magnitude as the area light's dimensions. 
 	  area_light x*1.5, z*1.5 25,25 adaptive 1 jitter orient circular
 	#end
	fade_distance 10//LightDist*0.04
 	fade_power 2//ln(1/(sqrt(2)-1))/ln(2)
 	media_interaction on
 	media_attenuation on
 	translate LightPos
	rotate x*60
	rotate y*0
 	#if (ParaLight)
		point_at <0.15,0,0.25>
	#end
	#if (SpotLight)	
		point_at <0,0,0>
		radius 1.35
		falloff 1.5
		tightness 0
	#end
	#if (UsePhotons)
    photons {reflection on refraction on}
  #end
 	}
#end

#declare SkyDome =
sphere{0, 1 hollow
	texture {
  	pigment { rgb 1}
			/*image_map {
				hdr "te-atatu-sunset-1.hdr"
				map_type 1
				interpolate 2
				}
			}*/
		finish {
			ambient 0
			diffuse 0
			emission 1
			}
		}
	rotate y*220
	//radiosity {importance 0.1}
	};

#declare Povray_Logo_Prism =
merge {
   cylinder {-z, z, 1 translate 2*y}
   difference {
      prism {-0.9999, 0.9999, 4, <-1,2>, <1,2>, <0,-4>, <-1,2> rotate -90*x}
      cylinder {-z, z, 1.4 scale <1,0.9,1.1> translate 1.9*y}
   }
   difference {
      cylinder {-z, z, 1 scale <2.6, 2.2, 1>}
      cylinder {-z, z, 1 scale <2.22, 1.72, 1.1> translate <-0.43, 0, 0>}
      rotate z*30 translate 2*y
   }
   rotate <0, 0, -25>
   translate <-0.5,-0.35,0>
   scale <1/4,1/4,1/8>
};


object { SkyDome rotate x*35 rotate y*90	scale 50}
//object {Table translate -y*tabletop}

object {
	Povray_Logo_Prism
	material {
		texture {
			pigment {rgb <1,0.35,0.05>}
			finish {
				ambient 0
				diffuse 0.5
				subsurface { translucency rgb <1,1,0.05> }
				}
			}
		interior {
			ior 1.8
			}
		}
	rotate x*90
	}




#if ( DoObjects )

		
#else



	

#end



