#ifndef POVRAY_BASE_METADATA_H
#define POVRAY_BASE_METADATA_H

#include "base/image/image.h"

#include <string>
namespace pov_base
{

   class Metadata
   {
      public:
         Metadata(){}
         ~Metadata(){}
         /* Software string should be at most 40 ascii bytes */
         static string getSoftware(){ return PACKAGE_STRING;}
         /* Up to 4 comments, each at most 80 ascii bytes */
         static string getComment1(){ return string("Build for ")+BUILT_FOR; }
         static string getComment2(){ return string("Compiled with ")+COMPILER_VERSION; }
         static string getComment3()
         { return string("Supported image formats: ")+BUILTIN_IMG_FORMATS; }
         static string getComment4()
         { 
            char silly[70];
            sprintf(silly,"File name limit: %d",FILE_NAME_LENGTH);
            return silly;
         }
         static string getDateTime()
         {
            time_t t;
            char val[60];
            struct tm tmp;
            t=time(NULL);
            localtime_r(&t,&tmp);
            // iso 8601 format
            strftime(val,60,"%Y-%m-%d %T%z",&tmp);
            return val;
         }
         static void fillDate(char * p)
         {
            // 6 shorts: month, day, year, hour, minute, second
            // always intel order (LSB first)
            time_t t;
            struct tm tmp;
            t=time(NULL);
            gmtime_r(&t,&tmp);
            *(p)=tmp.tm_mon+1;
            *(p+1)=0;
            *(p+2)=tmp.tm_mday;
            *(p+3)=0;
            *(p+4)=(1900+tmp.tm_year)%256;
            *(p+5)=(1900+tmp.tm_year)/256;
            *(p+6)=tmp.tm_hour;
            *(p+7)=0;
            *(p+8)=tmp.tm_min;
            *(p+9)=0;
            *(p+10)=tmp.tm_sec;
            *(p+11)=0;
         }
   };
}
#endif
