/*******************************************************************************
 * pvguiext.h
 *
 * This file contains POV-Ray for Windows GUI Extension specific defines.
 *
 * Author: Christopher J. Cason.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/windows/pvguiext.h $
 * $Revision: #11 $
 * $Change: 4548 $
 * $DateTime: 2008/02/10 04:52:50 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef PVGUIEXT_H_INCLUDED
#define PVGUIEXT_H_INCLUDED

#define MAX_GUI_EXT               32
#define GUI_INTERFACE_VERSION     101

#define CONTACT "Do not contact the POV-Team about this error. Contact the author of this extension - \n\n\t" AUTHOR " at " EMAIL

namespace povwin
{

using namespace pov;

#ifndef POVWIN_FILE
// WARNING: also declared in pvengine.h (for a reason)
// KEEP THESE IN SYNC
typedef enum
{
  mUnknown = 0,
  mAll = 1,
  All = 1,
  mIDE,
  mBanner,
  mWarning,
  mRender,
  mStatus,
  mDebug,
  mFatal,
  mStatistics,
  mDivider,
  mHorzLine,
} msgtype ;
#endif

#define MAX_QUEUE       512
#define OLD_MAX_QUEUE   128

typedef struct
{
  int                   RecSize ;
  char                  command_line [_MAX_PATH * 3] ;
  char                  source_file_name [_MAX_PATH] ;
  char                  lastRenderName [_MAX_PATH] ;
  char                  lastRenderPath [_MAX_PATH] ;
  char                  lastQueuePath [_MAX_PATH] ;
  char                  lastSecondaryIniFilePath [_MAX_PATH] ;
  char                  DefaultRenderIniFileName [_MAX_PATH] ;
  char                  SecondaryRenderIniFileName [_MAX_PATH] ;
  char                  SecondaryRenderIniFileSection [64] ;
  char                  ourPath [_MAX_PATH] ;
  char                  engineHelpPath [_MAX_PATH] ;
  char                  rendererHelpPath [_MAX_PATH] ;
  char                  HomePath [_MAX_PATH] ;
  char                  EngineIniFileName [_MAX_PATH] ;
  char                  ToolIniFileName [_MAX_PATH] ;
  unsigned              loadRerun ;
  unsigned              continueRerun ;
  unsigned              povray_return_code ;
  BOOL                  rendering ;
  BOOL                  IsWin32 ;
  BOOL                  IsW95UserInterface ;
  BOOL                  running_demo ;
  BOOL                  debugging ;
  BOOL                  isMaxiMinimized ;
  BOOL                  newVersion ;
  BOOL                  use_threads ;
  BOOL                  use_toolbar ;
  BOOL                  use_tooltips ;
  BOOL                  use_editors ;
  BOOL                  drop_to_editor ;
  BOOL                  rendersleep ;
  BOOL                  ExtensionsEnabled ;
  char                  queued_files [OLD_MAX_QUEUE] [_MAX_PATH] ;
  unsigned              queued_file_count ;
  unsigned              auto_render ;
  DWORD                 Reserved [32] ;
} ExternalVarStruct ;

typedef enum
{
  EventFirst,
  EventStartRendering,
  EventStopRendering,
  EventDisplayInit,
  EventDisplayFinished,
  EventDisplayClose,
  EventWinStartup,
  EventWinFinish,
  EventWinCooperate,
  EventLoadToolMenu,
  EventTimer,
  EventSize,
  EventMove,
  EventClose,
  EventDestroy,
  EventLast
} ExternalEvents ;

typedef enum
{
  RequestFirst,
  RequestGetVars,
  RequestSetVars,
  RequestStartRendering,
  RequestStopRendering,
  RequestExit,
  RequestSetCooperateLevel,
  RequestLast
} ExternalRequests ;

typedef enum
{
  ExRequestDisabled,
  ExRequestOK,
  ExRequestFailed,
  ExRequestFailedRendering,
  ExRequestFailedNotRendering,
  ExRequestBadRecSize,
  ExRequestUnknown
} ExternalRequestResult ;

typedef enum
{
  dfRealDrop,
  dfRenderEditor,
  dfRenderMessage,
  dfRenderCommandLine,
  dfRenderSourceFile,
  dfRenderFileQueue
} ExternalDropType ;

typedef struct
{
  // data POV passes to the DLL
  LPSTR                 PovVersion ;
  LPSTR                 GuiVersion ;
  DWORD                 GuiInterfaceVersion ;
  WPARAM                FirstMenuItem ;
  HINSTANCE             hInst ;
  HWND                  MainWindow ;
  ExternalRequestResult (WINAPI *ExternalRequest) (ExternalRequests Request, void *RequestBlock) ;

  // data the DLL passes to POV
  LPSTR                 Name ;
  LPSTR                 Author ;
  LPSTR                 AuthorEmail ;
  HMENU                 hMenu ;
  DWORD                 DLLInterfaceVersion ;
  char                  Agreement [1024] ;
} GuiExtInitStruct ;

typedef struct
{
  DWORD                 InstanceID ;
  HMENU                 hMenu ;
  WPARAM                FirstMenuItem ;
} IDataStruct ;

typedef struct
{
  DWORD                 Signature ;
  DWORD                 InstanceID ;
  BOOL                  (WINAPI *Init) (DWORD InstanceID, int RecSize, GuiExtInitStruct *InitStruct) ;
  void                  (WINAPI *Destroy) (IDataStruct *InstanceData) ;
  DWORD                 (WINAPI *MenuSelect) (IDataStruct *InstanceData, WPARAM Code) ;
  LPSTR                 (WINAPI *MenuTip) (IDataStruct *InstanceData, WPARAM Code) ;
  DWORD                 (WINAPI *Event) (IDataStruct *InstanceData, ExternalEvents Event, DWORD EventVal) ;
  void                  (WINAPI *DisplayPlot) (IDataStruct *InstanceData, int x, int y, int Red, int Green, int Blue, int Alpha) ;
  void                  (WINAPI *DisplayPlotRect) (IDataStruct *InstanceData, int x1, int y1, int x2, int y2, int Red, int Green, int Blue, int Alpha) ;
  void                  (WINAPI *WinPrePixel) (IDataStruct *InstanceData, int x, int y, COLOUR colour) ;
  void                  (WINAPI *WinPostPixel) (IDataStruct *InstanceData, int x, int y, COLOUR colour) ;
  BOOL                  (WINAPI *WinSystem) (IDataStruct *InstanceData, LPSTR command, int *returnval) ;
  void                  (WINAPI *CleanupAll) (IDataStruct *InstanceData) ;
  void                  (WINAPI *BufferMessage) (IDataStruct *InstanceData, msgtype message_type, LPSTR message) ;
  LPSTR                 (WINAPI *ParseToolCommand) (IDataStruct *InstanceData, char command [512]) ;
  BOOL                  (WINAPI *DragFunction) (IDataStruct *InstanceData, LPSTR szFile, ExternalDropType DropType) ;
  DWORD                 Reserved [128] ;
} GuiPointerBlock_Version_100 ;

typedef struct
{
  DWORD                 Signature ;
  DWORD                 InstanceID ;
  BOOL                  (WINAPI *Init) (DWORD InstanceID, int RecSize, GuiExtInitStruct *InitStruct) ;
  void                  (WINAPI *Destroy) (IDataStruct *InstanceData) ;
  DWORD                 (WINAPI *MenuSelect) (IDataStruct *InstanceData, WPARAM Code) ;
  LPSTR                 (WINAPI *MenuTip) (IDataStruct *InstanceData, WPARAM Code) ;
  DWORD                 (WINAPI *Event) (IDataStruct *InstanceData, ExternalEvents Event, DWORD EventVal) ;
  void                  (WINAPI *DisplayPlot) (IDataStruct *InstanceData, int x, int y, int Red, int Green, int Blue, int Alpha) ;
  void                  (WINAPI *DisplayPlotRect) (IDataStruct *InstanceData, int x1, int y1, int x2, int y2, int Red, int Green, int Blue, int Alpha) ;
  void                  (WINAPI *WinPrePixel) (IDataStruct *InstanceData, int x, int y, COLOUR colour) ;
  void                  (WINAPI *WinPostPixel) (IDataStruct *InstanceData, int x, int y, COLOUR colour) ;
  BOOL                  (WINAPI *WinSystem) (IDataStruct *InstanceData, LPSTR command, int *returnval) ;
  void                  (WINAPI *CleanupAll) (IDataStruct *InstanceData) ;
  void                  (WINAPI *BufferMessage) (IDataStruct *InstanceData, msgtype message_type, LPSTR message) ;
  LPSTR                 (WINAPI *ParseToolCommand) (IDataStruct *InstanceData, char command [512]) ;
  BOOL                  (WINAPI *DragFunction) (IDataStruct *InstanceData, LPSTR szFile, ExternalDropType DropType) ;
  void                  (WINAPI *AssignPixel) (IDataStruct *InstanceData, int x, int y, COLOUR colour) ;
  DWORD                 Reserved [127] ;
} GuiPointerBlock ;

DWORD ExternalEvent (ExternalEvents Event, DWORD EventVal) ;
void ExternalDisplayPlot (int x, int y, int Red, int Green, int Blue, int Alpha) ;
void ExternalDisplayPlotRect (int x1, int y1, int x2, int y2, int Red, int Green, int Blue, int Alpha) ;
void ExternalWinPrePixel (int x, int y, COLOUR colour) ;
void ExternalWinPostPixel (int x, int y, COLOUR colour) ;
void ExternalAssignPixel (int x, int y, COLOUR colour) ;
BOOL ExternalWinSystem (LPSTR command, int *returnval) ;
void ExternalCleanupAll (void) ;
void ExternalBufferMessage (msgtype message_type, LPSTR message) ;
void ExternalParseToolCommand (char command [512]) ;
BOOL ExternalDragFunction (LPSTR szFile, ExternalDropType DropType) ;
void LoadGUIExtensions (void) ;
DWORD ExternalMenuSelect (WPARAM Code) ;
char *ExternalMenuTip (WPARAM wParam) ;
BOOL CheckGUIExtLoaded (const char *Name) ;

}

#endif // PVGUIEXT_H_INCLUDED

