/*******************************************************************************
 * editorinterface.h
 *
 * This file is part of the CodeMax editor support code.
 *
 * Author: Christopher J. Cason.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/windows/codemax/cmedit/editorinterface.h $
 * $Revision: #5 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef __EDITORINTERFACE_H__
#define __EDITORINTERFACE_H__

extern "C" __declspec (dllexport) HWND CreateTabWindow (HWND mainWindow, HWND StatusWindow, char *HomePath) ;
extern "C" __declspec (dllexport) DWORD GetDLLVersion (void) ;
extern "C" __declspec (dllexport) void SetWindowPosition (int x, int y, int w, int h) ;
extern "C" __declspec (dllexport) void SetMessageWindow (HWND MsgWindow) ;
extern "C" __declspec (dllexport) void RestoreState (int RestoreFiles) ;
extern "C" __declspec (dllexport) void SaveState (void) ;
extern "C" __declspec (dllexport) bool SelectFile (const char *FileName) ;
extern "C" __declspec (dllexport) bool ShowParseError (char *FileName, char *Message, int Line, int Col) ;
extern "C" __declspec (dllexport) bool BrowseFile (bool CreateNewWindow) ;
extern "C" __declspec (dllexport) bool LoadFile (char *FileName) ;
extern "C" __declspec (dllexport) bool ExternalLoadFile (char *ParamString) ;
extern "C" __declspec (dllexport) bool CloseFile (char *FileName) ;
extern "C" __declspec (dllexport) bool SaveFile (char *FileName) ;
extern "C" __declspec (dllexport) DWORD GetTab (void) ;
extern "C" __declspec (dllexport) DWORD GetFlags (void) ;
extern "C" __declspec (dllexport) char *GetFilename (void) ;
extern "C" __declspec (dllexport) void NextTab (bool Forward) ;
extern "C" __declspec (dllexport) bool CanClose (bool AllFiles) ;
extern "C" __declspec (dllexport) bool SaveModified (char *FileName) ;
extern "C" __declspec (dllexport) bool ShowMessages (bool on) ;
extern "C" __declspec (dllexport) void DispatchMenuId (DWORD id) ;
extern "C" __declspec (dllexport) HMENU GetMenuHandle (int which) ;
extern "C" __declspec (dllexport) void SetNotifyBase (HWND WindowHandle, int MessageBase) ;
extern "C" __declspec (dllexport) void UpdateMenus (HMENU MenuHandle) ;
extern "C" __declspec (dllexport) void GetContextHelp (void) ;
extern "C" __declspec (dllexport) void SetTabFocus (void) ;
extern "C" __declspec (dllexport) bool PassOnMessage (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam, DWORD *rVal) ;
extern "C" __declspec (dllexport) void SetKeywords (LPCSTR Keywords) ;
extern "C" __declspec (dllexport) const char **GetWindowList (void);

void PutStatusMessage (LPCSTR Message) ;
void debug (char *format, ...) ;
void TabIndexChanged (void) ;
void ShowMessage (LPCSTR str, int type = 0) ;
void ShowErrorMessage (CStdString Title, const char *Msg, int ErrorCode = 0) ;
void GetFileTimeFromDisk (LPCSTR Filename, FILETIME& time) ;
bool FileExists (LPCSTR FileName) ;
void MakeFileNames (EditTagStruct *t, LPCSTR str) ;
CStdString GetFilePath (LPCSTR str) ;
CStdString GetFileExt (LPCSTR str) ;
CStdString GetFullPath (LPCSTR str) ;
CStdString GetBaseName (LPCSTR str) ;
CStdString GetFileNameNoExt (LPCSTR str) ;
CStdString FixPath (CStdString Name) ;
CStdString UnquotePath (CStdString Name) ;
int GetFileLength (LPCSTR FileName) ;
void AddToRecent (LPCSTR FileName) ;
void UpdateRecent (void) ;
CCodeMax *CreateNewEditor (const char *FileName, bool ReadOnly, bool Show) ;
bool CloseAll (void) ;
bool CloseFile (char *FileName) ;
bool SaveAllFiles (bool IncludeUntitled) ;
void ShowMessagePane (void) ;
bool HaveWin98OrLater (void) ;
bool HaveWin2kOrLater (void) ;
bool HaveWinXPOrLater (void) ;
CCodeMax *FindEditor (LPCSTR FileName) ;
void InsertTab (LPCSTR title) ;
void DeleteTab (int index) ;
void SetWindowPosition (void) ;

#endif
