/*******************************************************************************
 * syspovconfig.h
 *
 * This file contains most Windows specific defines for compiling the VFE.
 *
 * Author: Christopher J. Cason
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 2005-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/vfe/win/syspovconfig.h $
 * $Revision: #21 $
 * $Change: 4557 $
 * $DateTime: 2008/02/16 00:15:52 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef __SYSPOVCONFIG_H__
#define __SYSPOVCONFIG_H__

#ifdef BUILDING_AMD64
  #ifndef _M_AMD64
    #error you are compiling the AMD64 project using a 32-bit compiler
  #endif
#else
  #ifdef _M_AMD64
    #error you are compiling the 32-bit project using a 64-bit compiler
  #endif
#endif

#include <math.h>

// stop Window's objidl.h from being pulled in (which dupes IStream)
#define WIN32_LEAN_AND_MEAN

//#define PROFILE_CALLS

#ifdef _WIN64
  #define POVRAY_PLATFORM_NAME "unofficial-win64"
#else
  #define POVRAY_PLATFORM_NAME "unofficial-win32"
#endif

#define OPENEXR_MISSING         1

#define ReturnAddress()           NULL

#include "../vfeconf.h"

#if defined(__MINGW32__)                    /* MinGW GCC */
  #include "compilers/mingw32.h"
#elif defined(__WATCOMC__)                  /* Watcom C/C++ C32 */
  #include "compilers/watcom.h"
#elif defined(__BORLANDC__)                 /* Borland C/C++ */
  #include "compilers/borland.h"
#elif defined(_MSC_VER)                     /* Microsoft and Intel C++ */
  #include "compilers/msvc.h"
#else
  #error unknown compiler configuration
#endif

#ifdef BUILD_SSE2
  #define SSE2_INCLUDED "-sse2"
#else
  #define SSE2_INCLUDED ""
#endif

/////////////////////////////////////////////////////////////

#ifndef MAX
  #define MAX(a,b) ((a>b)?a:b)
#endif
#ifndef MIN
  #define MIN(a,b) ((a>b)?b:a)
#endif

#ifndef HEAPSHRINK
  #define HEAPSHRINK
#endif

#ifndef NAN
  #define NAN (10E100)
#endif

#ifndef __GENDEFS
  #define __GENDEFS
  typedef unsigned char     uchar;
  typedef unsigned short    ushort;
  typedef unsigned int      uint;
  typedef unsigned long     ulong;
  typedef unsigned __int64  uint64;
  typedef __int64           int64;
#endif

#include <stdarg.h>
#include <stdlib.h>

#ifdef __INTEL_COMPILER
// Intel C++ whines about the lack of a return on RDTSC() for each and every file
// it is included in. VC++ is smarter (or dumber, depending on your point of view).
#pragma warning(push)
#pragma warning(disable : 1011)
#endif

namespace povwin
{
  void WIN_Debug_Log(unsigned int from, const char *msg) ;
  void WIN32_DEBUG_OUTPUT(const char *format,...) ;
  void WIN32_DEBUG_FILE_OUTPUT(const char *format,...) ;
  void *win_malloc(size_t size);
  void *win_malloc(size_t size, const void *ptr, int line);
  void *win_calloc(size_t nelem, size_t size);
  void *win_calloc(size_t nelem, size_t size, const void *ptr, int line);
  void *win_realloc(void *p, size_t size);
  void *win_realloc(void *p, size_t size, const void *ptr, int line);
  void win_free(void *p);
  void win_free(void *p, const void *ptr, int line);
  char *win_strdup(const char *s);
  char *win_strdup(const char *s, const void *ptr, int line);
  bool WinMemReport(bool global, uint64& allocs, uint64& frees, int64& current, uint64& peak, uint64& smallest, uint64& largest);
  void WinMemStage(bool BeginRender, void *cookie = NULL);

#ifndef _WIN64
  inline void DebugBreak() { _asm _emit 0cch } // rather than use the windows one
  inline POV_LONG RDTSC(){ _asm _emit 0Fh _asm _emit 31h }
  #define READ_PROFILE_TIMER RDTSC()
#else
  inline void DebugBreak() {}
  #define READ_PROFILE_TIMER 0
#endif
}
#ifdef __INTEL_COMPILER
#pragma warning(pop)
#endif

#define ALTMAIN
#define LITTLE_ENDIAN
#define FILENAME_SEPARATOR                  '\\'
#define POV_FILE_SEPARATOR                  '\\'
#define DEFAULT_OUTPUT_FORMAT               'b'
#define POV_IS1                             ".bmp"
#define POV_IS2                             ".BMP"
#define DEFAULT_DISPLAY_GAMMA               2.2
#define DEFAULT_FILE_GAMMA                  2.2
#define DEFAULT_ASSUMED_GAMMA               1.0
#define RENAME_FILE(orig,new)               rename(orig,new)
#define DELETE_FILE(name)                   _unlink(name)
#define NEW_LINE_STRING                     "\r\n"
#define TEXTSTREAM_CRLF                     1
#define POV_SYS_FILE_EXTENSION              ".bmp"
#define SYS_TO_STANDARD                     BMP
#define vsnprintf                           _vsnprintf
#define FILE_NAME_LENGTH                    _MAX_PATH
#define POV_NAME_MAX                        _MAX_FNAME
#define IFF_SWITCH_CAST                     (long)
#define USE_OFFICIAL_BOOST                  1

#define MEM_STATS                           0
#define POV_MEM_STATS                       1
#define POV_MEMMOVE(dst,src,len)            memmove((dst),(src),(len))
#define POV_MEMCPY(dst,src,len)             memcpy((dst),(src),(len))

#ifdef _DEBUG
  #define POV_MALLOC(size,msg)              povwin::win_malloc ((size), __FILE__, __LINE__)
  #define POV_CALLOC(nitems,size,msg)       povwin::win_calloc ((nitems), (size), __FILE__, __LINE__)
  #define POV_REALLOC(ptr,size,msg)         povwin::win_realloc ((ptr), (size), __FILE__, __LINE__)
  #define POV_FREE(ptr)                     { povwin::win_free ((void *)(ptr), __FILE__, __LINE__); (ptr) = NULL; }
  #define POV_STRDUP(str)                   povwin::win_strdup(str, __FILE__, __LINE__)
#else
  #define POV_MALLOC(size,msg)              povwin::win_malloc (size)
  #define POV_CALLOC(nitems,size,msg)       povwin::win_calloc ((nitems), (size))
  #define POV_REALLOC(ptr,size,msg)         povwin::win_realloc ((ptr), (size))
  #define POV_FREE(ptr)                     { povwin::win_free ((void *)(ptr)); (ptr) = NULL; }
  #define POV_STRDUP(str)                   povwin::win_strdup(str)
#endif

#define POV_GLOBAL_MEM_STATS(a,f,c,p,s,l)   povwin::WinMemReport(true, a, f, c, p, s, l)
#define POV_THREAD_MEM_STATS(a,f,c,p,s,l)   povwin::WinMemReport(false, a, f, c, p, s, l)
#define POV_MEM_STATS_RENDER_BEGIN()        povwin::WinMemStage(true)
#define POV_MEM_STATS_RENDER_END()          povwin::WinMemStage(false)
#define POV_MEM_STATS_COOKIE                void *

#define POV_IMPLEMENT_RTR                   1
#define SYS_IMAGE_HEADER                    "syspovimage.h"
#define POV_VIDCAP_IMPL                     pov::VideoCaptureImpl
namespace pov
{
  class VideoCaptureImpl;
}

// see RLP comment in 3.6 windows config.h
#undef HUGE_VAL

// use a larger buffer for more efficient parsing
#define DEFAULT_ITEXTSTREAM_BUFFER_SIZE 65536

// this adds some useful debugging information to each POV-Ray SDL object
#if defined _DEBUG
  #define OBJECT_DEBUG_HELPER
#endif

#ifndef MAX_PATH
  #define MAX_PATH _MAX_PATH
#endif

#define NEED_INVHYP

#ifndef NO_RTR
  #define RTR_HACK
  #define RTR_SUPPORT
#endif

#endif // __SYSPOVCONFIG_H__
