/*******************************************************************************
 * objects.h
 *
 * This module contains all defines, typedefs, and prototypes for OBJECTS.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/source/backend/scene/objects.h $
 * $Revision: #20 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

/* NOTE: FRAME.H contains other object stuff. */

#ifndef OBJECTS_H
#define OBJECTS_H

namespace pov
{

using namespace std;

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*
 * [DB 7/94]
 *
 * The flag field is used to store all possible flags that are
 * used for objects (up to 32).
 *
 * The flages are manipulated using the following macros:
 *
 *   Set_Flag    (Object, Flag) : set    specified Flag in Object
 *   Clear_Flag  (Object, Flag) : clear  specified Flag in Object
 *   Invert_Flag (Object, Flag) : invert specified Flag in Object
 *   Test_Flag   (Object, Flag) : test   specified Flag in Object
 *
 *   Copy_Flag   (Object1, Object2, Flag) : Set the Flag in Object1 to the
 *                                          value of the Flag in Object2.
 *   Bool_Flag   (Object, Flag, Bool)     : if(Bool) Set flag else Clear flag
 *
 * Object is a pointer to the object.
 * Flag is the number of the flag to test.
 *
 */

#define NO_SHADOW_FLAG            0x00000001L /* Object doesn't cast shadows            */
#define CLOSED_FLAG               0x00000002L /* Object is closed                       */
#define INVERTED_FLAG             0x00000004L /* Object is inverted                     */
#define SMOOTHED_FLAG             0x00000008L /* Object is smoothed                     */
#define CYLINDER_FLAG             0x00000010L /* Object is a cylinder                   */
#define DEGENERATE_FLAG           0x00000020L /* Object is degenerate                   */
#define STURM_FLAG                0x00000040L /* Object should use sturmian root solver */
#define OPAQUE_FLAG               0x00000080L /* Object is opaque                       */
#define MULTITEXTURE_FLAG         0x00000100L /* Object is multi-textured               */
#define INFINITE_FLAG             0x00000200L /* Object is infinite                     */
#define HIERARCHY_FLAG            0x00000400L /* Object can have a bounding hierarchy   */
#define HOLLOW_FLAG               0x00000800L /* Object is hollow (atmosphere inside)   */
#define HOLLOW_SET_FLAG           0x00001000L /* Hollow explicitly set in scene file    */
#define UV_FLAG                   0x00002000L /* Object uses UV mapping                 */
#define DOUBLE_ILLUMINATE_FLAG    0x00004000L /* Illuminate both sides of the surface   */
#define NO_IMAGE_FLAG             0x00008000L /* Object doesn't catch camera rays    [ENB 9/97] */
#define NO_REFLECTION_FLAG        0x00010000L /* Object doesn't cast reflection rays [ENB 9/97] */
#define NO_GLOBAL_LIGHTS_FLAG     0x00020000L /* Object doesn't receive light from global lights */
#define NO_GLOBAL_LIGHTS_SET_FLAG 0x00040000L /* Object doesn't receive light from global lights explicitly set in scene file */
/* Photon-related flags */
#define PH_TARGET_FLAG            0x00080000L /* object receives photons */
#define PH_PASSTHRU_FLAG          0x00100000L /* this is pass through object */
#define PH_RFL_ON_FLAG            0x00200000L /* this object reflects photons */
#define PH_RFL_OFF_FLAG           0x00400000L /* this object does not reflect photons */
#define PH_RFR_ON_FLAG            0x00800000L /* this object refracts photons */
#define PH_RFR_OFF_FLAG           0x01000000L /* this object does not refract photons */
#define PH_IGNORE_PHOTONS_FLAG    0x02000000L /* this object ignores photons */
#define NO_RADIOSITY_FLAG         0x04000000L /* Object doesn't receive ambient light from radiosity */



#define Set_Flag(Object, Flag)     \
  { Object->Flags |=  (Flag); }

#define Clear_Flag(Object, Flag)   \
  { Object->Flags &= ~(Flag); }

#define Invert_Flag(Object, Flag)  \
  { Object->Flags ^=  (Flag); }

#define Test_Flag(Object, Flag)    \
  (Object->Flags & (Flag))

#define Copy_Flag(Object1, Object2, Flag) \
  { Object1->Flags = ((Object1->Flags) & (~Flag)) | \
                       ((Object2->Flags) &  (Flag)); }

#define Bool_Flag(Object, Flag, Bool) \
  { if(Bool){ Object->Flags |=  (Flag); } else { Object->Flags &= ~(Flag); }}



/* Object types. */

#define BASIC_OBJECT                0
#define PATCH_OBJECT                1 /* Has no inside, no inverse */
#define TEXTURED_OBJECT             2 /* Has texture, possibly in children */
#define IS_COMPOUND_OBJECT          4 /* Has children field */
#define STURM_OK_OBJECT             8 /* STURM legal */
//#define WATER_LEVEL_OK_OBJECT      16 /* WATER_LEVEL legal */
#define LIGHT_SOURCE_OBJECT        32 /* link me in frame.light_sources */
#define BOUNDING_OBJECT            64 /* This is a holder for bounded object */
//#define SMOOTH_OK_OBJECT          128 /* SMOOTH legal */
#define IS_CHILD_OBJECT           256 /* Object is inside a COMPOUND */
/* NK 1998 - DOUBLE_ILLUMINATE is not used anymore - use DOUBLE_ILLUMINATE_FLAG */
#define HIERARCHY_OK_OBJECT       512 /* NO_HIERARCHY legal */
#define LT_SRC_UNION_OBJECT      1024 /* Union of light_source objects only */
#define LIGHT_GROUP_OBJECT       2048 /* light_group union object [trf] */
#define LIGHT_GROUP_LIGHT_OBJECT 4096 /* light in light_group object [trf] */
#define CSG_DIFFERENCE_OBJECT    8192 /* csg difference object */
#define IS_CSG_OBJECT           16384 /* object is a csg and not some other compound object */
#define CHILDREN_FLAGS (PATCH_OBJECT+TEXTURED_OBJECT)  /* Reverse inherited flags */


/*****************************************************************************
* Global functions
******************************************************************************/

bool Find_Intersection(Intersection *Ray_Intersection, ObjectPtr Object, Ray& ray, const TraceThreadData *Thread);
bool Find_Intersection(Intersection *isect, ObjectPtr object, Ray& ray, ObjectBase::BBoxDirection variant, const BBOX_VECT& origin, const BBOX_VECT& invdir, const TraceThreadData *threadData);
bool Ray_In_Bound(Ray& ray, vector<ObjectPtr>& Bounding_Object, const TraceThreadData *Thread);
bool Point_In_Clip(VECTOR IPoint, vector<ObjectPtr>& Clip, const TraceThreadData *Thread);
ObjectPtr Copy_Object(ObjectPtr Old);
vector<ObjectPtr> Copy_Objects(vector<ObjectPtr>& Src);
void Translate_Object(ObjectPtr Object, VECTOR Vector, TRANSFORM *Trans);
void Rotate_Object(ObjectPtr Object, VECTOR Vector, TRANSFORM *Trans);
void Scale_Object(ObjectPtr Object, VECTOR Vector, TRANSFORM *Trans);
void Transform_Object(ObjectPtr Object, TRANSFORM *Trans);
bool Inside_Object(VECTOR IPoint, ObjectPtr Vector, const TraceThreadData *Thread);
void Invert_Object(ObjectPtr& Object);
void Destroy_Object(vector<ObjectPtr>& Object);
void Destroy_Object(ObjectPtr Object);
void Destroy_Single_Object(ObjectPtr *ObjectPtr);

}

#endif
