/*******************************************************************************
 * radiosity.h
 *
 * This file contains radiosity computation classes and types.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/source/backend/lighting/radiosity.h $
 * $Revision: #16 $
 * $Change: 4528 $
 * $DateTime: 2008/02/04 08:36:09 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef POVRAY_BACKEND_RADIOSITY_H
#define POVRAY_BACKEND_RADIOSITY_H

#include "backend/frame.h"
#include "backend/povray.h"
#include "backend/scene/view.h"
#include "backend/scene/scene.h"
#include "backend/render/tracepixel.h"
#include "backend/render/rendertask.h"
#include "backend/support/octree.h"
#include "backend/lighting/photons.h"
#include "backend/interior/media.h"

#include "povrayold.h" // TODO FIXME

namespace pov
{

class ViewData;

#define RADIOSITY_CACHE_EXTENSION ".rca"

const unsigned int MAX_NEAREST_COUNT = 20;
const unsigned int BLOCK_POOL_UNIT_SIZE = 32;

class RadiosityCache;

class RadiosityFunction : public Trace::RadiosityFunctor
{
	public:
		RadiosityFunction(shared_ptr<SceneData> sd, TraceThreadData *td, unsigned int mtl, DBL adcb,
		                  const RadiositySettings& rs, RadiosityCache& rc, Trace::CooperateFunctor& cf, bool ft);

		virtual void ComputeAmbient(const Ray& ray, const Vector3d& ipoint, const Vector3d& raw_normal, Vector3d layer_normal, RGBColour& ambient_colour, DBL weight);

		virtual bool CheckRadiosityTraceLevel();
	private:
		Trace trace;
		MediaFunction media;
		PhotonGatherer photonGatherer;
		RadiosityCache& radiosityCache;
		Vector3d sampleDirections[1600];
		DBL adcBailout;
		DBL errorBound;
		DBL realErrorBound;
		DBL minimumReuseRadius;
		unsigned int nearestReuseCount;
		unsigned int sampleCount;
		unsigned int maxAllowedRadiosityLevel;
		COLC grayLight;
		COLC ambientBrightness;
		COLC maximumSampleBrightness;
		bool addSamplesOnFinalTrace;
		bool useLayerNormal;
		bool isFinalTrace;

		void GatherLight(const Ray& ray, const Vector3d& IPoint, const Vector3d& Raw_Normal, const Vector3d& LayNormal, RGBColour& Illuminance, DBL Weight);
		bool ComputeSampleDirection(unsigned int sample_count, const Vector3d& raw_normal, const Vector3d& layer_normal,
		                            const Vector3d& n2, const Vector3d& n3, Vector3d& direction, unsigned int& cursample, bool& use_raw_normal);
};

class RadiosityCache
{
	public:
		int firstRadiosityPass;

		long ra_reuse_count;
		long ra_gather_count;

		RGBColour Gather_Total;
		long Gather_Total_Count;
		Colour Setting_Total;
		long Setting_Total_Count;

		#ifdef RADSTATS
			extern long ot_blockcount;
			long ot_seenodecount;
			long ot_seeblockcount;
			long ot_doblockcount;
			long ot_dotokcount;
			long ot_lastcount;
			long ot_lowerrorcount;
		#endif

		OStream *ot_fd;
		UCS2String inputFile;
		UCS2String outputFile;

		RadiosityCache(RadiositySettings& radset);
		~RadiosityCache();

		OT_BLOCK *NewBlock();
		void InsertBlock(const Vector3d& ipoint, DBL radius, OT_BLOCK *block);

		int FindReusableBlock(DBL errorbound, const Vector3d& ipoint, const Vector3d& snormal, RGBColour& illuminance, int tracelevel);
	private:
		struct BlockPoolUnit
		{
			BlockPoolUnit *next;
			unsigned int nextFreeBlock;
			OT_BLOCK blocks[BLOCK_POOL_UNIT_SIZE];

			BlockPoolUnit(BlockPoolUnit *n) : next(n), nextFreeBlock(0) { }
		};

		BlockPoolUnit *blockPool;
		boost::mutex blockPoolMutex;

		OT_NODE *ot_root;
		boost::mutex otMutex;

		static bool AverageNearBlock(OT_BLOCK *block, void *void_info);
};

}

#endif // POVRAY_BACKEND_RADIOSITY_H
